﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>


<script runat="server">

	public class Confirmation : ContextBase
	{
		public Confirmation(Context context)
			: base(context)
		{ }


		[Caption("Wykonać przeliczenie")]
		public bool Confirm { get; set; }
	}


	[Context]
	public Confirmation Pars { get; set; }


	private void dc_ContextLoad(Object sender, EventArgs e)
	{
		if (!Pars.Confirm)
			throw new Exception("Anulowano przeliczenie");

		Log log = new Log(Log.Progress);
		Row[] rows = (Row[])dc[typeof(Row[])];
		
		int c = rows.Length;
		int i = 0;

		using (var cn = dc.Session.Login.Database.OpenConnectionWithTransaction(Soneta.Business.App.DatabaseType.Operational))
		{
			using (Session sess = dc.Session.Login.CreateSession(false, false, "Tools - zapłaty na rozliczane"))
			{
				using (ITransaction t = sess.Logout(true))
				{
					foreach (IRozliczalny rozliczalny in rows)
					{
						log.WriteLine(new Percent((decimal)++i / c));

						Zaplata zap = rozliczalny as Zaplata;
						if (zap == null || zap.Rozliczana)
							continue;

						cn.ExecuteCommand(Soneta.Business.App.ExecuteMode.NonQuery, String.Format("update Zaplaty set Rozliczana = 1 where id = {0}", zap.ID));
                        cn.ExecuteCommand(Soneta.Business.App.ExecuteMode.NonQuery, String.Format("insert into RozrachunkiIdx (DokumentType, Dokument, EwidencjaSP, DataRozliczenia,DataPierwszego,Data,Typ,Numer) values ('Zaplaty',{0},{1},'2004-1-1','2004-1-1','2004-1-1',1,'aaaa')", zap.ID, zap.EwidencjaSP.ID));

						IRozliczalny r = (IRozliczalny)sess[(Row)rozliczalny];
						RozrachunkiIdx.Przelicz(r);
					}

					t.Commit();
				}

				sess.Save();
			}

			cn.Commit();
		}

		throw new CancelException();
	}
    

</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Tools</title>
</head>
<body>
	<form method="post" runat="server">
		<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
	</form>
</body>
</html>
